/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.util;

import ch.icit.util.FieldFilter;
import ch.icit.util.InvokerException;
import ch.icit.util.TypeInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Invoker {
    private static Logger log = LoggerFactory.getLogger(Invoker.class);
    public static final FieldFilter excludeFinalStaticFieldFilter = new FieldFilter(){

        @Override
        public boolean isFieldValid(Field field) {
            int modifiers = field.getModifiers();
            return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers);
        }
    };
    private static Map<Class<?>, Map<String, Field>> fieldIndex = new HashMap();
    public static Map<Class<?>, Map<String, Method>> methodIndex = new HashMap();

    private Invoker() {
    }

    public static int getFieldCount(Class<?> clazz) {
        int fieldCount = 0;
        for (Class<?> cC = clazz; cC != null; cC = cC.getSuperclass()) {
            fieldCount += cC.getDeclaredFields().length;
        }
        return fieldCount;
    }

    public static int getFieldCountNonStatic(Class<?> clazz) {
        int fieldCount = 0;
        for (Class<?> cC = clazz; cC != null; cC = cC.getSuperclass()) {
            for (Field field : cC.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                ++fieldCount;
            }
        }
        return fieldCount;
    }

    public static boolean excecuteMethod(String methodName, Object object) {
        Method method = null;
        block4: for (Class<?> cC = object.getClass(); cC != null && method == null; cC = cC.getSuperclass()) {
            Method[] met;
            for (Method m : met = cC.getDeclaredMethods()) {
                if (!m.getName().equals(methodName)) continue;
                method = m;
                continue block4;
            }
        }
        if (method != null) {
            try {
                method.setAccessible(true);
                method.invoke(object, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                log.trace("Unable to excecute Methode " + methodName + ", (IllegalArguments) msg: " + e.getMessage());
                return false;
            }
            catch (IllegalAccessException e) {
                log.trace("Unable to excecute Methode " + methodName + ", (IllegalAccess) msg: " + e.getMessage());
                return false;
            }
            catch (InvocationTargetException e) {
                log.trace("Unable to excecute Methode " + methodName + ", (InvocationTarget) msg: " + e.getMessage());
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isConcreteClass(Class<?> clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract(modifiers);
    }

    public static boolean fieldExists(Class<?> clazz, String fieldName) throws InvokerException {
        try {
            clazz.getDeclaredField(fieldName);
            return true;
        }
        catch (SecurityException e) {
            throw new InvokerException(e.getMessage(), e);
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public static boolean getterExists(Class<?> clazz, String fieldName) {
        try {
            Invoker.getGetter(fieldName, clazz);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
        catch (InvokerException e) {
            return false;
        }
    }

    public static List<Class<?>> getAllClasses(Class<?> clazz) {
        ArrayList classes = new ArrayList();
        for (Class<?> tClazz = clazz; tClazz != Object.class; tClazz = tClazz.getSuperclass()) {
            classes.add(tClazz);
        }
        return classes;
    }

    public static Map<Class<?>, List<String>> getAllFieldNames(Class<?> clazz) {
        HashMap fields = new HashMap();
        for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (Field f : c.getDeclaredFields()) {
                fieldNames.add(f.getName());
            }
            fields.put(c, fieldNames);
        }
        return fields;
    }

    public static List<Field> getAllFields(Class<?> clazz, FieldFilter filter) {
        HashSet<String> fieldNames = new HashSet<String>();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if (filter != null && !filter.isFieldValid(f) || fieldNames.contains(f.getName())) continue;
                fields.add(f);
                fieldNames.add(f.getName());
            }
        }
        return fields;
    }

    public static Annotation[] getFieldAnnotations(String fieldName, Class<? extends Object> clazz) throws InvokerException {
        Field field = Invoker.getField(clazz, fieldName);
        if (field == null) {
            throw new InvokerException(Invoker.noSuchField(clazz, fieldName));
        }
        return field.getType().getAnnotations();
    }

    private static String noSuchField(Class<?> clazz, String fieldName) {
        return "A field with the name '" + fieldName + "' does not exist in the class '" + clazz.getSimpleName() + "' and it's super classes!";
    }

    public static Class<?> getFirstGenericFieldType(Field field) throws InvokerException {
        TypeInfo genericType = Invoker.getGenericTypeInfo(field);
        if (genericType == null || genericType.getActualTypes().isEmpty()) {
            return null;
        }
        return genericType.getActualTypes().get(0).getRawType();
    }

    public static TypeInfo getGenericTypeInfo(Field field) throws InvokerException {
        return Invoker.getTypeInfo(field.getGenericType(), new HashMap<Type, TypeInfo>());
    }

    private static TypeInfo getTypeInfo(Type t, Map<Type, TypeInfo> registry) {
        Type[] bounds;
        if (registry.containsKey(t)) {
            return registry.get(t);
        }
        TypeInfo typeInfo = null;
        if (Class.class.isInstance(t)) {
            typeInfo = new TypeInfo((Class)t);
            registry.put(t, typeInfo);
        } else if (ParameterizedType.class.isInstance(t)) {
            typeInfo = Invoker.getTypeInfo((ParameterizedType)t, registry);
        } else if (TypeVariable.class.isInstance(t) && (bounds = ((TypeVariable)t).getBounds()).length > 0 && bounds[0] instanceof ParameterizedType) {
            typeInfo = Invoker.getTypeInfo((ParameterizedType)bounds[0], registry);
        }
        return typeInfo;
    }

    private static TypeInfo getTypeInfo(ParameterizedType type, Map<Type, TypeInfo> registry) {
        if (registry.containsKey(type)) {
            return registry.get(type);
        }
        TypeInfo typeInfo = new TypeInfo((Class)type.getRawType());
        registry.put(type, typeInfo);
        for (Type t : type.getActualTypeArguments()) {
            typeInfo.addType(Invoker.getTypeInfo(t, registry));
        }
        return typeInfo;
    }

    public static Class<?> getFieldType(String fieldName, Class<?> clazz) throws InvokerException {
        Field field = Invoker.getField(clazz, fieldName);
        if (field == null) {
            throw new InvokerException(Invoker.noSuchField(clazz, fieldName));
        }
        return field.getType();
    }

    public static void setFieldValue(Field field, Object value, Object object, boolean useSetter) throws InvokerException {
        if (useSetter) {
            Invoker.invokeSetter(object, field.getName(), value);
        } else {
            Invoker.setFieldValue(field, value, object);
        }
    }

    public static void setFieldValue(String fieldName, Object value, Object object, boolean useSetter) throws InvokerException {
        if (useSetter) {
            Invoker.invokeSetter(object, fieldName, value);
        } else {
            Invoker.setFieldValue(object, fieldName, value);
        }
    }

    private static void setFieldValue(Field field, Object value, Object object) throws InvokerException {
        Invoker.validateNotNull(new Object[]{field, object}, new String[]{"field", "object"});
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (Exception e) {
            throw new InvokerException("Failed to set the value of the field '" + field.getName() + "' of the class '" + object.getClass().getSimpleName() + "' (" + e.getMessage() + ")!", e);
        }
    }

    private static void validateNotNull(Object[] objs, String[] names) throws InvokerException {
        for (int i = 0; i < objs.length; ++i) {
            Invoker.validateNotNull(objs[i], names[i]);
        }
    }

    private static void validateNotNull(Object obj, String name) throws InvokerException {
        if (obj == null) {
            throw new InvokerException(name + " is null!");
        }
    }

    private static void setFieldValue(Object object, String fieldName, Object value) throws InvokerException {
        Invoker.setFieldValue(Invoker.getField(object.getClass(), fieldName), value, object);
    }

    private static void invokeSetter(Object object, String fieldName, Object value) throws InvokerException {
        Method setter;
        block5: {
            String methodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            Class<?> fieldType = Invoker.getFieldType(fieldName, object.getClass());
            setter = null;
            try {
                setter = Invoker.getMethod(object.getClass(), fieldName, methodName, null, fieldType);
            }
            catch (InvokerException e) {
                try {
                    if (Invoker.isPrimitiveType(fieldType)) {
                        setter = fieldType.isPrimitive() ? Invoker.getMethod(object.getClass(), fieldName, methodName, null, Invoker.getWrapperClass(fieldType)) : Invoker.getMethod(object.getClass(), fieldName, methodName, null, Invoker.getPrimitiveClass(fieldType));
                    }
                }
                catch (InvokerException invokerException) {
                    // empty catch block
                }
                if (setter != null) break block5;
                throw new InvokerException("Failed to access the setter method for the field '" + fieldName + "' of the class '" + object.getClass().getSimpleName() + "' (" + e.getMessage() + ")!", e);
            }
        }
        Invoker.invokeMethod(object, setter, value);
    }

    public static Object getFieldValue(Field field, Object object) throws InvokerException {
        return Invoker.getFieldValue(field.getName(), object, null);
    }

    public static <T> T getFieldValue(Field field, Object object, Class<T> expectedFieldType, boolean useGetter) throws InvokerException {
        return useGetter ? Invoker.invokeGetter(field.getName(), object, expectedFieldType) : Invoker.getFieldValue(field, object, expectedFieldType);
    }

    public static <T> T getFieldValue(String fieldName, Object object, Class<T> expectedFieldType, boolean useGetter) throws InvokerException {
        return useGetter ? Invoker.invokeGetter(fieldName, object, expectedFieldType) : Invoker.getFieldValue(fieldName, object, expectedFieldType);
    }

    public static <T> T getFieldValue(Field field, Object object, Class<T> expectedFieldType) throws InvokerException {
        Object returnValue = null;
        field.setAccessible(true);
        try {
            returnValue = field.get(object);
        }
        catch (IllegalArgumentException e) {
            throw new InvokerException("Failed to get the value of the field '" + object.getClass().getSimpleName() + "." + field.getName() + "' (" + e.getMessage() + ")!", e);
        }
        catch (IllegalAccessException e) {
            throw new InvokerException("Failed to get the value of the field '" + object.getClass().getSimpleName() + "." + field.getName() + "' (" + e.getMessage() + ")!", e);
        }
        try {
            return Invoker.convertToExpectedType(returnValue, expectedFieldType);
        }
        catch (InvokerException e) {
            throw new InvokerException("The value contained in the field '" + field.getDeclaringClass().getSimpleName() + "." + field.getName() + "' (" + returnValue.getClass().getSimpleName() + ") does not match the expected type (" + expectedFieldType.getSimpleName() + ")!", e);
        }
    }

    public static Object getFieldValue(String fieldName, Object object) throws InvokerException {
        return Invoker.getFieldValue(fieldName, object, null);
    }

    public static <T> T getFieldValue(String fieldName, Object object, Class<T> expectedReturnType) throws InvokerException {
        if (object == null) {
            throw new IllegalArgumentException("object must not be null!");
        }
        Field field = Invoker.getField(object.getClass(), fieldName);
        if (field == null) {
            throw new InvokerException("The class '" + object.getClass().getSimpleName() + "' does not contain a field with the name '" + fieldName + "'!");
        }
        return Invoker.getFieldValue(field, object, expectedReturnType);
    }

    public static <T> T getMethodValue(String methodName, Object object) throws InvokerException {
        String t = "get" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        Method m = Invoker.getMethod(object.getClass(), null, t, null, new Class[0]);
        if (m == null) {
            return null;
        }
        return (T)Invoker.invokeMethod(object, m, new Object[0]);
    }

    private static <T> T invokeGetter(String fieldName, Object object, Class<T> expectedReturnType) throws InvokerException {
        Method getter = Invoker.getGetter(fieldName, object.getClass());
        Object returnValue = Invoker.invokeMethod(object, getter, new Object[0]);
        try {
            return Invoker.convertToExpectedType(returnValue, expectedReturnType);
        }
        catch (InvokerException e) {
            throw new InvokerException("The method '" + getter.getName() + "' of the class '" + object.getClass().getSimpleName() + "' is expected to be the getter for the field '" + fieldName + "' but the returned type (" + returnValue.getClass().getSimpleName() + ") does not match the expected return type (" + expectedReturnType.getSimpleName() + ")!", e);
        }
    }

    private static Method getGetter(String fieldName, Class<?> clazz) throws InvokerException {
        Method getter;
        String suffix = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        try {
            getter = Invoker.getMethod(clazz, fieldName, "get" + suffix, "is" + suffix, new Class[0]);
        }
        catch (InvokerException e) {
            throw new InvokerException("Failed to access the getter method for the field '" + fieldName + "' of the class '" + clazz.getSimpleName() + "' (" + e.getMessage() + ")!", e);
        }
        return getter;
    }

    private static <T> T convertToExpectedType(Object object, Class<T> expectedType) throws InvokerException {
        if (expectedType == null) {
            return (T)object;
        }
        if (object == null) {
            return null;
        }
        Class<?> expected = Invoker.getWrapperClass(expectedType);
        if (expected.equals(object.getClass())) {
            return (T)object;
        }
        if (!expected.isAssignableFrom(object.getClass())) {
            throw new InvokerException("Incompatible types (object type: " + object.getClass().getSimpleName() + ", expected type: " + expectedType.getSimpleName() + " ");
        }
        if (!Invoker.isConcreteClass(expected)) {
            return (T)object;
        }
        Object target = Invoker.instantiate(expected);
        for (Field field : Invoker.getAllFields(expected, excludeFinalStaticFieldFilter)) {
            Object value = Invoker.getFieldValue(field, object);
            Invoker.setFieldValue(field, value, target, false);
        }
        return (T)target;
    }

    public static boolean isPrimitiveType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.equals(Integer.class)) {
            return true;
        }
        if (clazz.equals(Short.class)) {
            return true;
        }
        if (clazz.equals(Byte.class)) {
            return true;
        }
        if (clazz.equals(Character.class)) {
            return true;
        }
        if (clazz.equals(Double.class)) {
            return true;
        }
        if (clazz.equals(Float.class)) {
            return true;
        }
        if (clazz.equals(Long.class)) {
            return true;
        }
        if (clazz.equals(Boolean.class)) {
            return true;
        }
        return clazz.equals(Void.class);
    }

    public static Class<?> getWrapperClass(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz.getName().equals("int")) {
            return Integer.class;
        }
        if (clazz.getName().equals("short")) {
            return Short.class;
        }
        if (clazz.getName().equals("byte")) {
            return Byte.class;
        }
        if (clazz.getName().equals("char")) {
            return Character.class;
        }
        if (clazz.getName().equals("double")) {
            return Double.class;
        }
        if (clazz.getName().equals("float")) {
            return Float.class;
        }
        if (clazz.getName().equals("long")) {
            return Long.class;
        }
        if (clazz.getName().equals("boolean")) {
            return Boolean.class;
        }
        if (clazz.getName().equals("void")) {
            return Void.class;
        }
        throw new RuntimeException("Failed to get the wrapper class for the class '" + clazz.getName() + "'!");
    }

    public static Class<?> getPrimitiveClass(Class<?> clazz) {
        if (clazz.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (clazz.equals(Short.class)) {
            return Short.TYPE;
        }
        if (clazz.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (clazz.equals(Character.class)) {
            return Character.TYPE;
        }
        if (clazz.equals(Double.class)) {
            return Double.TYPE;
        }
        if (clazz.equals(Float.class)) {
            return Float.TYPE;
        }
        if (clazz.equals(Long.class)) {
            return Long.TYPE;
        }
        if (clazz.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (clazz.getName().equals("void")) {
            return Void.TYPE;
        }
        throw new RuntimeException("Failed to get the primitive class for the class '" + clazz.getName() + "'!");
    }

    public static List<Throwable> validateAllFields(Object object) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        Class<?> clazz = object.getClass();
        Map<Class<?>, List<String>> fieldNames = Invoker.getAllFieldNames(clazz);
        for (Map.Entry<Class<?>, List<String>> entry : fieldNames.entrySet()) {
            for (String fieldName : entry.getValue()) {
                try {
                    Invoker.validateField(fieldName, object);
                }
                catch (InvokerException e) {
                    errors.add(e);
                }
            }
        }
        if (errors.isEmpty()) {
            log.debug("Successfully validated all fields of the class '" + clazz.getSimpleName() + "'.");
        } else {
            log.debug(errors.size() + " error(s) occured while validating the class '" + clazz.getSimpleName() + "'!");
        }
        return errors;
    }

    public static void validateField(String fieldName, Object object) throws InvokerException {
        Class<?> clazz = object.getClass();
        Field field = Invoker.getField(clazz, fieldName);
        if (field == null) {
            throw new InvokerException(Invoker.noSuchField(clazz, fieldName));
        }
        Class<?> fieldType = field.getType();
        int fieldModifiers = field.getModifiers();
        boolean callGetter = true;
        boolean callSetter = true;
        if (Modifier.isStatic(fieldModifiers)) {
            callGetter = false;
            callSetter = false;
        } else if (Modifier.isFinal(fieldModifiers)) {
            callSetter = false;
        }
        if (callGetter) {
            Object value = Invoker.getFieldValue(field, object, fieldType);
            if (callSetter) {
                Invoker.setFieldValue(field, value, object);
            }
        }
        log.debug("Successfully validated the field '" + fieldName + "' of the class '" + clazz.getSimpleName() + "'.");
    }

    private static void createFieldNameIndex(Class<?> clazz, Class<?> indexClazz) {
        Map<String, Field> index = fieldIndex.get(indexClazz);
        if (index == null) {
            index = new HashMap<String, Field>();
            fieldIndex.put(indexClazz, index);
        }
        for (Field f : clazz.getDeclaredFields()) {
            index.put(f.getName(), f);
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            Invoker.createFieldNameIndex(clazz.getSuperclass(), indexClazz);
        }
    }

    public static Field getField(Class<?> clazz, String fieldName) throws InvokerException {
        Field f = Invoker.getFieldNew(clazz, fieldName);
        if (f == null) {
            return Invoker.getFieldOld(clazz, fieldName);
        }
        return f;
    }

    private static Field getFieldNew(Class<?> clazz, String fieldName) throws InvokerException {
        Map<String, Field> innerIndex = fieldIndex.get(clazz);
        if (innerIndex == null) {
            Invoker.createFieldNameIndex(clazz, clazz);
            innerIndex = fieldIndex.get(clazz);
        }
        return innerIndex.get(fieldName);
    }

    private static Field getFieldOld(Class<?> clazz, String fieldName) throws InvokerException {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            log.trace("Found the field '" + fieldName + "' in the class '" + clazz.getSimpleName() + "'");
            return field;
        }
        catch (NoSuchFieldException e) {
            StringBuilder message = new StringBuilder();
            message.append("A field with the name '").append(fieldName);
            message.append("' was not found in the class '").append(clazz.getSimpleName()).append("'");
            if (clazz.getSuperclass() != Object.class) {
                Class<?> superClass = clazz.getSuperclass();
                message.append(". Looking in the superclass '" + superClass.getSimpleName() + "' ...");
                log.trace(message.toString());
                return Invoker.getField(superClass, fieldName);
            }
            log.trace(message.toString());
            return null;
        }
        catch (SecurityException e) {
            throw new InvokerException(e);
        }
    }

    private static void createMethodNameIndex(Class<?> clazz, Class<?> indexClazz) {
        Map<String, Method> index = methodIndex.get(indexClazz);
        if (index == null) {
            index = new HashMap<String, Method>();
            methodIndex.put(indexClazz, index);
        }
        for (Method f : clazz.getMethods()) {
            index.put(f.getName(), f);
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            Invoker.createMethodNameIndex(clazz.getSuperclass(), indexClazz);
        }
    }

    private static Method getMethod(Class<?> clazz, String fieldName, String methodName, String alternativeMethodName, Class<?> ... parameterTypes) throws InvokerException {
        Method m = Invoker.getMethodNew(clazz, fieldName, methodName, alternativeMethodName, parameterTypes);
        if (m == null) {
            return Invoker.getMethodOld(clazz, fieldName, methodName, alternativeMethodName, parameterTypes);
        }
        return m;
    }

    private static Method getMethodNew(Class<?> clazz, String fieldName, String methodName, String alternativeMethodName, Class<?> ... parameterTypes) throws InvokerException {
        Method r;
        Map<String, Method> index = methodIndex.get(clazz);
        if (index == null) {
            Invoker.createMethodNameIndex(clazz, clazz);
            index = methodIndex.get(clazz);
        }
        if ((r = index.get(methodName)) == null) {
            r = index.get(alternativeMethodName);
        }
        if (r == null) {
            // empty if block
        }
        return r;
    }

    private static Method getMethodOld(Class<?> clazz, String fieldName, String methodName, String alternativeMethodName, Class<?> ... parameterTypes) throws InvokerException {
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            log.trace("Found the method '" + method.getName() + "' in the class '" + clazz.getSimpleName() + "'.");
            return method;
        }
        catch (NoSuchMethodException e) {
            Class<?> fieldType;
            StringBuilder l = new StringBuilder();
            l.append("A method with the name '").append(methodName).append("' ");
            if (parameterTypes != null && parameterTypes.length > 0) {
                l.append("and the parameter type");
                if (parameterTypes.length == 1) {
                    l.append(" '").append(parameterTypes[0].getSimpleName()).append("' ");
                } else {
                    l.append("s '");
                    l.append(parameterTypes[0].getSimpleName());
                    for (int i = 1; i < parameterTypes.length; ++i) {
                        l.append(", ").append(parameterTypes[i].getSimpleName());
                    }
                    l.append("' ");
                }
            }
            l.append("was not found in the class '");
            l.append(clazz.getSimpleName());
            boolean alternativeMethod = false;
            if (alternativeMethodName != null && ((fieldType = Invoker.getFieldType(fieldName, clazz)).equals(Boolean.class) || fieldType.equals(Boolean.TYPE))) {
                alternativeMethod = true;
            }
            if (alternativeMethod) {
                log.trace(l + ". Looking for a method with the alternative name '" + alternativeMethodName + "'");
                try {
                    Method method = clazz.getDeclaredMethod(alternativeMethodName, parameterTypes);
                    log.trace("Found the method '" + method.getName() + "' in the class '" + clazz.getSimpleName() + "'.");
                    return method;
                }
                catch (NoSuchMethodException e1) {
                    l = new StringBuilder();
                    l.append("Neither a method with the name '").append(methodName);
                    l.append("' nor with the alternative name '").append(alternativeMethodName);
                    l.append("' were found in the class '").append(clazz.getSimpleName());
                }
                catch (SecurityException e1) {
                    throw new InvokerException(e.getMessage(), e);
                }
            } else {
                log.trace(l + ". No alternative method name available.");
            }
            if (clazz.getSuperclass() != Object.class) {
                Class<?> superClass = clazz.getSuperclass();
                log.trace("Looking in the superclass '" + superClass.getSimpleName() + "' for the method '" + methodName + "' ...");
                try {
                    return Invoker.getMethod(superClass, fieldName, methodName, alternativeMethodName, parameterTypes);
                }
                catch (InvokerException invokerException) {
                    // empty catch block
                }
            }
            l.append("' or in super classes of it");
            throw new InvokerException(l.toString());
        }
        catch (SecurityException e) {
            throw new InvokerException(e.getMessage(), e);
        }
    }

    private static Object invokeMethod(Object object, Method method, Object ... args) throws InvokerException {
        try {
            method.setAccessible(true);
            return method.invoke(object, args);
        }
        catch (InvocationTargetException e) {
            throw new InvokerException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new InvokerException("Failed to invoke the method '" + method.getName() + "' on an instance of the class '" + object.getClass().getSimpleName() + "' (" + e.getMessage() + ")!", e);
        }
    }

    public static void copyFieldValue(Object sourceObj, String sourceField, Object targetObj, String targetField) throws InvokerException {
        Object fieldValue = Invoker.getFieldValue(sourceField, sourceObj);
        Invoker.setFieldValue(targetObj, targetField, fieldValue);
    }

    public static <T> T instantiate(Class<T> clazz) throws InvokerException {
        if (!Invoker.isConcreteClass(clazz)) {
            throw new InvokerException("Failed to instantiate the class '" + clazz.getSimpleName() + "' (the class is not a concrete implementation)!");
        }
        try {
            T instance = clazz.newInstance();
            return instance;
        }
        catch (InstantiationException e) {
            throw new InvokerException("Failed to instantiate the class '" + clazz.getSimpleName() + "'!", e);
        }
        catch (IllegalAccessException e) {
            throw new InvokerException(e);
        }
    }

    public static Method getMethod(Annotation anno, String methodName) {
        for (Method meth : anno.annotationType().getMethods()) {
            if (!meth.getName().equals(methodName)) continue;
            return meth;
        }
        return null;
    }

    public static <A extends Annotation> A getClassAnnotation(Class<?> clazz, Class<A> annotationClass) {
        A anno = null;
        for (Class<?> currentClass = clazz; currentClass != null && anno == null; currentClass = currentClass.getSuperclass()) {
            anno = currentClass.getAnnotation(annotationClass);
        }
        return anno;
    }
}

